<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:26.032535468 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Neoverse-N2" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleNeoverseN2CPU_CYCLES &gt; 0), ($InstructionsPerCycleNeoverseN2INST_RETIRED / $InstructionsPerCycleNeoverseN2CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Neoverse-N2)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesNeoverseN2CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesNeoverseN2STALL_FRONTEND / $FrontendStalledCyclesNeoverseN2CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesNeoverseN2CPU_CYCLES &gt; 0), min(($BackendStalledCyclesNeoverseN2STALL_BACKEND / $BackendStalledCyclesNeoverseN2CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Neoverse-N2)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundNeoverseN2CPU_CYCLES &gt; 0), min(((($FrontendBoundNeoverseN2STALL_SLOT_FRONTEND - $FrontendBoundNeoverseN2CPU_CYCLES) / ($FrontendBoundNeoverseN2CPU_CYCLES * 5)) - (($FrontendBoundNeoverseN2BR_MIS_PRED * 1) / $FrontendBoundNeoverseN2CPU_CYCLES)), 1), 0)" name="Frontend Bound (tel_v0)" units="percent"/>
        <series color="255,0,102" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundNeoverseN2CPU_CYCLES &gt; 0), min((($FrontendBoundNeoverseN2STALL_SLOT_FRONTEND / ($FrontendBoundNeoverseN2CPU_CYCLES * 5)) - (($FrontendBoundNeoverseN2BR_MIS_PRED * 1) / $FrontendBoundNeoverseN2CPU_CYCLES)), 1), 0)" name="Frontend Bound (tel_v1)" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundNeoverseN2CPU_CYCLES &gt; 0), min((($BackendBoundNeoverseN2STALL_SLOT_BACKEND / ($BackendBoundNeoverseN2CPU_CYCLES * 5)) - (($BackendBoundNeoverseN2BR_MIS_PRED * 3) / $BackendBoundNeoverseN2CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringNeoverseN2CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringNeoverseN2OP_SPEC &gt; 0), min(((1 - ($RetiringNeoverseN2STALL_SLOT / ($RetiringNeoverseN2CPU_CYCLES * 5))) * ($RetiringNeoverseN2OP_RETIRED / $RetiringNeoverseN2OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringNeoverseN2CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringNeoverseN2OP_SPEC &gt; 0), min((($RetiringNeoverseN2OP_RETIRED / $RetiringNeoverseN2OP_SPEC) * (1 - (($RetiringNeoverseN2STALL_SLOT - $RetiringNeoverseN2CPU_CYCLES) / ($RetiringNeoverseN2CPU_CYCLES * 5)))), 1), 0)" name="Retiring (tel_v0)" units="percent"/>
        <series color="102,255,0" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationNeoverseN2CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationNeoverseN2OP_SPEC &gt; 0), min((((1 - ($BadSpeculationNeoverseN2OP_RETIRED / $BadSpeculationNeoverseN2OP_SPEC)) * (1 - (($BadSpeculationNeoverseN2STALL_SLOT - $BadSpeculationNeoverseN2CPU_CYCLES) / ($BadSpeculationNeoverseN2CPU_CYCLES * 5)))) + (($BadSpeculationNeoverseN2BR_MIS_PRED * 4) / $BadSpeculationNeoverseN2CPU_CYCLES)), 1), 0)" name="Bad Speculation (tel_v0)" units="percent"/>
        <series color="128,77,0" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationNeoverseN2CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationNeoverseN2OP_SPEC &gt; 0), min((((1 - ($BadSpeculationNeoverseN2OP_RETIRED / $BadSpeculationNeoverseN2OP_SPEC)) * (1 - ($BadSpeculationNeoverseN2STALL_SLOT / ($BadSpeculationNeoverseN2CPU_CYCLES * 5)))) + (($BadSpeculationNeoverseN2BR_MIS_PRED * 4) / $BadSpeculationNeoverseN2CPU_CYCLES)), 1), 0)" name="Bad Speculation (tel_v1)" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageNeoverseN2OP_SPEC &gt; 0), min(($RetiredOperationsPercentageNeoverseN2OP_RETIRED / $RetiredOperationsPercentageNeoverseN2OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKINeoverseN2INST_RETIRED &gt; 0), (($L1ICacheMPKINeoverseN2L1I_CACHE_REFILL / $L1ICacheMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageNeoverseN2L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageNeoverseN2L1I_CACHE_REFILL / $L1ICacheMissPercentageNeoverseN2L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKINeoverseN2INST_RETIRED &gt; 0), (($ITLBMPKINeoverseN2ITLB_WALK / $ITLBMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKINeoverseN2INST_RETIRED &gt; 0), (($L1InstructionTLBMPKINeoverseN2L1I_TLB_REFILL / $L1InstructionTLBMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageNeoverseN2L1I_TLB &gt; 0), min(($ITLBWalkPercentageNeoverseN2ITLB_WALK / $ITLBWalkPercentageNeoverseN2L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageNeoverseN2L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageNeoverseN2L1I_TLB_REFILL / $L1InstructionTLBMissPercentageNeoverseN2L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundNeoverseN2STALL_BACKEND &gt; 0), min(($BackendMemoryBoundNeoverseN2STALL_BACKEND_MEM / $BackendMemoryBoundNeoverseN2STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKINeoverseN2INST_RETIRED &gt; 0), (($L1DCacheMPKINeoverseN2L1D_CACHE_REFILL / $L1DCacheMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKINeoverseN2INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKINeoverseN2L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKINeoverseN2L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageNeoverseN2L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageNeoverseN2L1D_CACHE_REFILL / $L1DCacheMissPercentageNeoverseN2L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKINeoverseN2INST_RETIRED &gt; 0), (($L2CacheMPKINeoverseN2L2D_CACHE_REFILL / $L2CacheMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageNeoverseN2L2D_CACHE &gt; 0), min(($L2CacheMissPercentageNeoverseN2L2D_CACHE_REFILL / $L2CacheMissPercentageNeoverseN2L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKINeoverseN2INST_RETIRED &gt; 0), (($L3CacheMPKINeoverseN2L3D_CACHE_REFILL / $L3CacheMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageNeoverseN2L3D_CACHE &gt; 0), min(($L3CacheMissPercentageNeoverseN2L3D_CACHE_REFILL / $L3CacheMissPercentageNeoverseN2L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKINeoverseN2INST_RETIRED &gt; 0), (($LLCacheReadMPKINeoverseN2LL_CACHE_MISS_RD / $LLCacheReadMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageNeoverseN2LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageNeoverseN2LL_CACHE_MISS_RD / $LLCacheReadMissPercentageNeoverseN2LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageNeoverseN2LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageNeoverseN2LL_CACHE_RD - $LLCacheReadHitPercentageNeoverseN2LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageNeoverseN2LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKINeoverseN2INST_RETIRED &gt; 0), (($DTLBMPKINeoverseN2DTLB_WALK / $DTLBMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKINeoverseN2INST_RETIRED &gt; 0), (($L1DataTLBMPKINeoverseN2L1D_TLB_REFILL / $L1DataTLBMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKINeoverseN2INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKINeoverseN2L2D_TLB_REFILL / $L2UnifiedTLBMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory Bound) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageNeoverseN2L1D_TLB &gt; 0), min(($DTLBWalkPercentageNeoverseN2DTLB_WALK / $DTLBWalkPercentageNeoverseN2L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageNeoverseN2L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageNeoverseN2L1D_TLB_REFILL / $L1DataTLBMissPercentageNeoverseN2L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageNeoverseN2L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageNeoverseN2L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageNeoverseN2L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageNeoverseN2ISB_SPEC + $BarrierOperationsPercentageNeoverseN2DSB_SPEC) + $BarrierOperationsPercentageNeoverseN2DMB_SPEC) / $BarrierOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min((($BranchOperationsPercentageNeoverseN2BR_IMMED_SPEC + $BranchOperationsPercentageNeoverseN2BR_INDIRECT_SPEC) / $BranchOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min(($CryptoOperationsPercentageNeoverseN2CRYPTO_SPEC / $CryptoOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min(($IntegerOperationsPercentageNeoverseN2DP_SPEC / $IntegerOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageNeoverseN2VFP_SPEC / $FloatingPointOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageNeoverseN2ASE_SPEC / $AdvancedSIMDOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageNeoverseN2INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageNeoverseN2SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageNeoverseN2INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageNeoverseN2INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageNeoverseN2FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageNeoverseN2INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageNeoverseN2INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageNeoverseN2FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageNeoverseN2INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageNeoverseN2INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageNeoverseN2FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageNeoverseN2INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageNeoverseN2INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageNeoverseN2LDREX_SPEC / $LoadExclusiveInstructionsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageNeoverseN2INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageNeoverseN2STREX_SPEC / $StoreExclusiveInstructionsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min(($LoadOperationsPercentageNeoverseN2LD_SPEC / $LoadOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageNeoverseN2INST_SPEC &gt; 0), min(($StoreOperationsPercentageNeoverseN2ST_SPEC / $StoreOperationsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageNeoverseN2INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageNeoverseN2RC_LD_SPEC / $LoadAcquireInstructionsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageNeoverseN2INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageNeoverseN2RC_ST_SPEC / $StoreReleaseInstructionsPercentageNeoverseN2INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKINeoverseN2INST_RETIRED &gt; 0), (($BranchMPKINeoverseN2BR_MIS_PRED_RETIRED / $BranchMPKINeoverseN2INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Neoverse-N2)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageNeoverseN2BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageNeoverseN2BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageNeoverseN2BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Neoverse_N2_metric_backend_bound" />
    <select-metric id="ARMv8_Neoverse_N2_metric_backend_mem_bound" />
    <select-metric id="ARMv8_Neoverse_N2_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_N2_metric_bad_speculation_0_0" />
    <select-metric id="ARMv8_Neoverse_N2_metric_bad_speculation_0_3" />
    <select-metric id="ARMv8_Neoverse_N2_metric_barrier_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_branch_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_branch_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_crypto_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_fp16_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_fp32_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_fp64_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_frontend_bound_0_0" />
    <select-metric id="ARMv8_Neoverse_N2_metric_frontend_bound_0_3" />
    <select-metric id="ARMv8_Neoverse_N2_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_N2_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_ipc" />
    <select-metric id="ARMv8_Neoverse_N2_metric_itlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_N2_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Neoverse_N2_metric_load_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_retired_ops_percent" />
    <select-metric id="ARMv8_Neoverse_N2_metric_retiring" />
    <select-metric id="ARMv8_Neoverse_N2_metric_retiring_0_0" />
    <select-metric id="ARMv8_Neoverse_N2_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_simd_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_store_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_strex_percentage" />
    <select-metric id="ARMv8_Neoverse_N2_metric_sve_all_percentage" />
</template>
